<?php

/**
 * WooCommerce B2B Posts
 *
 * @version 3.0.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * WCB2B_Admin_Posts
 */
class WCB2B_Admin_Posts {

    /**
     * Constructor
     */
    public function __construct() {
        $this->init_hooks();
    }

    /**
     * Init current class hooks
     */
    public function init_hooks() {
        if ( get_option( 'wcb2b_page_visibility' ) === 'yes' ) {
            add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ), 10, 2 );
            add_action( 'save_post', array( $this, 'save_meta_box' ) );
        }

        add_filter( 'display_post_states', array( $this, 'post_state' ), 10, 2 );
    }

    /**
     * Add page/post visibility by group
     */
    public function add_meta_box( $post_type, $post ) {
        add_meta_box( 'wcb2b_group-visibility-meta_box', __( 'Group visibility', 'woocommerce-b2b' ), function( $post ) {
            // Make sure the form request comes from WordPress
            wp_nonce_field( basename( __FILE__ ), 'wcb2b_group-visibility-nonce' );

            // Retrieve post visibility current value and groups
            $groups = wcb2b_get_groups();
            $visibility = false;
            if ( metadata_exists( 'post', $post->ID, 'wcb2b_group_visibility' ) ) {
                $visibility = get_post_meta( $post->ID, 'wcb2b_group_visibility', true );
            }
            include_once WCB2B_ABSPATH . 'includes/views/html-admin-posts.php';
        }, array( 'page' ), 'side', 'low' );
    }

    /**
     * Save page/post visibility by group
     */
    public function save_meta_box( $post_id ) {
        if ( in_array( get_post_type( $post_id ), array( 'page' ) ) && ! in_array( $post_id, wcb2b_get_always_visible_pages() ) ) {

            // Verify meta box nonce
            if ( ! isset( $_POST['wcb2b_group-visibility-nonce'] ) || ! wp_verify_nonce( $_POST['wcb2b_group-visibility-nonce'], basename( __FILE__ ) ) ) { return; }

            $visibility = false;
            if ( isset( $_POST['wcb2b_group_visibility'] ) ) {
                // Sanitize values
                $visibility = array_map( 'intval', array_filter( $_POST['wcb2b_group_visibility'] ) );
            }
            update_post_meta( $post_id, 'wcb2b_group_visibility', $visibility );
        }
    }

    /**
     * Add post state to the quick order page 
     */
    public function post_state( $post_states, $post ) {
        if ( $post->ID == get_option( 'wcb2b_quick_order_page' ) ) {
            $post_states[] = __( 'Quick Order Page', 'woocommerce-b2b' );
        }
        return $post_states;
    }

}

return new WCB2B_Admin_Posts();