<?php

/**
 * WooCommerce B2B Configuration Class
 *
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WCB2B_Configuration', false ) ) :

    /**
     * WCB2B_Configuration Class
     */
    class WCB2B_Configuration {

        /**
         * Configuration
         *
         * @var array
         */
        private $configuration = array();

        /**
         * The single instance of the class
         *
         * @var WCB2B_Configuration
         */
        protected static $_instance = null;

        /**
         * Main WCB2B_Configuration Instance
         *
         * Ensures only one instance of WCB2B_Configuration is loaded or can be loaded
         * 
         * @static
         * @return WCB2B_Configuration - Main instance
         */
        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        /**
         * Load WooCommerce B2B configuration
         */
        public static function get_customer_statuses() {
            $customer_statuses = apply_filters( 'wcb2b_customer_statuses', array(
                0 => esc_html__( 'Inactive', 'woocommerce-b2b' ),
                1 => esc_html__( 'Active', 'woocommerce-b2b' )
            ) );
            return $customer_statuses;
        }

    }

endif;