<?php

/**
 * WooCommerce B2B Posts
 *
 * @version 3.0.3
 */

defined( 'ABSPATH' ) || exit;

/**
 * WCB2B_Frontend_Posts
 */
class WCB2B_Frontend_Posts {

    /**
     * Constructor
     */
    public function __construct() {
        $this->init_hooks();
    }

    /**
     * Init current class hooks
     */
    public function init_hooks() {
        if ( get_option( 'wcb2b_page_visibility' ) === 'yes' ) {
            add_action( 'template_redirect', array( $this, 'redirect' ), 10 );
            add_filter( 'wp_get_nav_menu_items', array( $this, 'remove_from_menu' ), 10, 3 );
            add_filter( 'get_pages', array( $this, 'remove_from_list' ), 10, 2 );
        }
    }

    /**
     * Redirect to choosed page if page is restricted
     */
    public function redirect() {
        if ( is_singular( array( 'page' ) ) && ! in_array( get_the_ID(), wcb2b_get_always_visible_pages() ) ) {
            $group_id = get_option( 'wcb2b_guest_group' );
            if ( is_user_logged_in() ) {
                if ( ! wcb2b_has_role( get_current_user_id(), 'customer' ) ) { return; }

                if ( $customer_group_id = get_the_author_meta( 'wcb2b_group', get_current_user_id() ) ) {
                    $group_id = $customer_group_id;
                }
            }
            $visibility = get_post_meta( get_the_ID(), 'wcb2b_group_visibility', true );
            if ( ! in_array( $group_id, (array)$visibility ) ) {
                if ( $redirect = apply_filters( 'wcb2b_redirect_hidden_page', false ) ) {
                    wp_safe_redirect( $redirect, 302 );
                    exit;
                }
                global $wp_query;
                $wp_query->set_404();
                status_header( 404 );
            }
        }
    }

    /**
     * Remove pages from menu
     * 
     * @param array $items Menu items
     * @param string $menu Menu name
     * @param array $args Menu arguments
     * @return array
     */
    public function remove_from_menu( $items, $menu, $args ) {
        $group_id = get_option( 'wcb2b_guest_group' );
        if ( is_user_logged_in() ) {
            if ( ! wcb2b_has_role( get_current_user_id(), 'customer' ) ) { return $items; }

            if ( $customer_group_id = get_the_author_meta( 'wcb2b_group', get_current_user_id() ) ) {
                $group_id = $customer_group_id;
            }
        }
        foreach ( $items as $key => $item ) {
            if ( ! in_array( $item->object_id, wcb2b_get_always_visible_pages() ) ) {
                $visibility = get_post_meta( $item->object_id, 'wcb2b_group_visibility', true );
                if ( in_array( get_post_type( $item->object_id ), array( 'page' ) ) && ! in_array( $group_id, (array)$visibility ) ) {
                    unset( $items[$key] );
                }
            }
        }
        return $items;
    }

    /**
     * Remove pages from lists
     * 
     * @param array $pages Pages list
     * @param string $r
     * @return array
     */
    public function remove_from_list( $pages, $r ) {
        if ( did_action( 'init' ) ) {
            $group_id = get_option( 'wcb2b_guest_group' );
            if ( is_user_logged_in() ) {
                if ( ! wcb2b_has_role( get_current_user_id(), 'customer' ) ) { return $pages; }

                if ( $customer_group_id = get_the_author_meta( 'wcb2b_group', get_current_user_id() ) ) {
                    $group_id = $customer_group_id;
                }
            }
            foreach ( $pages as $key => $page ) {
                if ( ! in_array( $page->ID, wcb2b_get_always_visible_pages() ) ) {
                    $visibility = get_post_meta( $page->ID, 'wcb2b_group_visibility', true );
                    if ( in_array( get_post_type( $page->ID ), array( 'page' ) ) && ! in_array( $group_id, (array)$visibility ) ) {
                        unset( $pages[$key] );
                    }
                }
            }
        }
        return $pages;
    }

}

return new WCB2B_Frontend_Posts();