<?php

/**
 * WooCommerce B2B Admin Product data tab
 *
 * @version 3.1.0
 */

defined( 'ABSPATH' ) || exit;

?>

<div class="wcb2b_options_group options_group show_if_simple show_if_variable hide_if_external">
    <div class="wcb2b-card">
        <input type="checkbox" id="wcb2b-collapse_<?php echo $post_id; ?>" checked>
        <div class="wcb2b-card-title">
            <?php esc_html_e( 'WooCommerce B2B', 'woocommerce-b2b' ); ?>
                
            <label for="wcb2b-collapse_<?php echo $post_id; ?>"></label>
        </div>
        <div class="wcb2b-card-body">
            <section class="wcb2b-section">
                <div class="wcb2b-heading"><?php esc_html_e( 'Inventory', 'woocommerce-b2b' ); ?></div>
                <div class="wcb2b-form">

                    <?php
                        woocommerce_wp_text_input( array(
                            'id'            => '_wcb2b_barcode',
                            'type'          => 'text',
                            'name'          => 'wcb2b_barcode[' . $post_id . ']',
                            'label'         => esc_html__( 'Barcode', 'woocommerce-b2b' ),
                            'description'   => esc_html__( 'Product barcode number (EAN/IAN/GTIN)', 'woocommerce-b2b' ),
                            'desc_tip'      => false,
                            'value'         => $barcode,
                            'wrapper_class' => 'wcb2b-form-field',
                            'required'      => false
                        ) );
                    ?>

                </div>
            </section>
            
            <?php if ( $groups->post_count ) : ?>

                <?php foreach ( $groups->posts as $group ) : ?>
                <section class="wcb2b-section">
                    <div class="wcb2b-heading"><?php printf( __( '%s group prices', 'woocommerce-b2b' ), get_the_title( $group->ID ) ); ?></div>
                    <div class="wcb2b-form">
                        
                        <?php
                            $args = array(
                                'id'            => '_wcb2b_product_group_hide_prices_' . $group->ID,
                                'value'         => 'no',
                                'cbvalue'       => 'yes',
                                'name'          => 'wcb2b_product_group_hide_prices[' . $post_id . '][' . $group->ID . ']',
                                'wrapper_class' => 'wcb2b-form-field',
                                'label'         => __( 'Hide price', 'woocommerce-b2b' ),
                                'description'   => __( 'Hide product price for this specific group', 'woocommerce-b2b' )
                            );
                            if ( is_array( $product_group_hide_prices ) && in_array( $group->ID, $product_group_hide_prices ) ) {
                                $args['value'] = 'yes';
                            }
                            if ( $group->ID == get_option( 'wcb2b_guest_group' ) && get_option( 'wcb2b_hide_prices' ) === 'yes' ) {
                                $args['value'] = 'yes';
                                $args['custom_attributes'] = array(
                                    'disabled' => true
                                );
                            }
                            woocommerce_wp_checkbox( $args );
                        ?>

                    </div>
                    <div class="wcb2b-form">

                        <?php
                            $args = array(
                                'id'            => '_wcb2b_product_group_hide_stocks_' . $group->ID,
                                'value'         => 'no',
                                'cbvalue'       => 'yes',
                                'name'          => 'wcb2b_product_group_hide_stocks[' . $post_id . '][' . $group->ID . ']',
                                'wrapper_class' => 'wcb2b-form-field',
                                'label'         => __( 'Hide stock', 'woocommerce-b2b' ),
                                'description'   => __( 'Hide product stock for this specific group', 'woocommerce-b2b' )
                            );
                            if ( is_array( $product_group_hide_stocks ) && in_array( $group->ID, $product_group_hide_stocks ) ) {
                                $args['value'] = 'yes';
                            }
                            if ( 'yes' != get_post_meta( $post_id, '_manage_stock', true ) ) {
                                $args['custom_attributes'] = array(
                                    'disabled' => true
                                );
                            }
                            woocommerce_wp_checkbox( $args );
                        ?>

                    </div>
                    <div class="wcb2b-form">

                        <?php
                            // Retrieve product prices by group
                            $regular_price = '';
                            $sale_price = '';
                            if ( is_array( $product_group_prices ) && array_key_exists( $group->ID, $product_group_prices ) ) {
                                if ( is_array( $product_group_prices[$group->ID] ) ) {
                                    if ( array_key_exists( 'regular_price', $product_group_prices[$group->ID] ) ) {
                                        if ( $regular_price = $product_group_prices[$group->ID]['regular_price'] ) {
                                            $regular_price = number_format(
                                                floatval( $regular_price ),
                                                wc_get_price_decimals(),
                                                wc_get_price_decimal_separator(),
                                                ''
                                            );
                                        }
                                    }
                                    if ( array_key_exists( 'sale_price', $product_group_prices[$group->ID] ) ) {
                                        if ( $sale_price = $product_group_prices[$group->ID]['sale_price'] ) {
                                            $sale_price = number_format(
                                                floatval( $sale_price ),
                                                wc_get_price_decimals(),
                                                wc_get_price_decimal_separator(),
                                                ''
                                            );
                                        }
                                    }
                                }
                            }

                            // Build regular price field
                            woocommerce_wp_text_input( array(
                                'id'            => '_wcb2b_product_group_regular_price_' . $group->ID,
                                'type'          => 'text',
                                'class'         => 'short wc_input_price',
                                'name'          => 'wcb2b_product_group_prices[' . $post_id . '][' . $group->ID . '][regular_price]',
                                'label'         => __( 'Regular price', 'woocommerce-b2b' ),
                                'value'         => $regular_price,
                                'required'      => true,
                                'wrapper_class' => 'wcb2b-form-field'
                            ) );

                            // Build sale price field
                            woocommerce_wp_text_input( array(
                                'id'            => '_wcb2b_product_group_sale_price_' . $group->ID,
                                'type'          => 'text',
                                'class'         => 'short wc_input_price',
                                'name'          => 'wcb2b_product_group_prices[' . $post_id . '][' . $group->ID . '][sale_price]',
                                'label'         => __( 'Sale price', 'woocommerce-b2b' ),
                                'value'         => $sale_price,
                                'required'      => true,
                                'wrapper_class' => 'wcb2b-form-field',
                            ) );
                        ?>

                        <p class="wcb2b-form-button">
                            <a class="button" href="" data-toggle="wcb2b-product_group_tier_prices-add" data-group="<?php echo $group->ID; ?>" data-post="<?php echo $post_id; ?>" data-label="<?php _e( 'Remove', 'woocommerce-b2b' ); ?>"><?php _e( 'Add tier price', 'woocommerce-b2b' ); ?></a>
                        </p>
                    </div>
                    <div class="wcb2b-panel">
                        <div class="wcb2b-label"><?php _e( 'Tier prices', 'woocommerce-b2b' ); ?></div>
                        <div class="wcb2b-panel-content">
                            <table>
                                <thead>
                                    <tr>
                                        <th width="40%"><?php _e( 'Min quantity', 'woocommerce-b2b' ); ?> <sup>*</sup></th>
                                        <th width="40%"><?php _e( 'Final discounted price', 'woocommerce-b2b' ); ?> <sup>*</sup></th>
                                        <th width="20%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    <?php
                                        if ( isset( $product_group_tier_prices[$group->ID] ) ) {
                                            foreach ( $product_group_tier_prices[$group->ID] as $quantity => $price ) {
                                                if ( $price ) {
                                                    $price = number_format(
                                                        floatval( $price ),
                                                        wc_get_price_decimals(),
                                                        wc_get_price_decimal_separator(),
                                                        ''
                                                    );
                                                }
                                                printf( '<tr>%s%s%s</tr>',
                                                    sprintf( '<td><input type="number" name="%s" value="%s" class="short" min="0" step="1" required></td>',
                                                        'wcb2b_product_group_tier_prices[' . $post_id . '][' . $group->ID . '][quantity][]',
                                                        $quantity
                                                    ),
                                                    sprintf( '<td><input type="text" name="%s" value="%s" class="wc_input_price" required></td>',
                                                        'wcb2b_product_group_tier_prices[' . $post_id . '][' . $group->ID . '][price][]',
                                                        $price
                                                    ),
                                                    sprintf( '<td><a class="%s" href="">%s</a></td>',
                                                        'button-link-delete',
                                                        __( 'Remove', 'woocommerce-b2b' )
                                                    )
                                                );
                                            }
                                        }
                                    ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
                <?php endforeach; ?>

            <?php endif; ?>

            <?php if ( $groups->post_count ) : ?>

                <?php foreach ( $groups->posts as $group ) : ?>
                <section class="wcb2b-section">
                    <div class="wcb2b-heading"><?php printf( __( '%s group min/max quantity and packages', 'woocommerce-b2b' ), get_the_title( $group->ID ) ); ?></div>
                    <div class="wcb2b-form wcb2b-form-inline">
                        
                        <?php
                            $args = array(
                                'id'            => '_wcb2b_product_group_packages_' . $group->ID,
                                'type'          => 'number',
                                'name'          => 'wcb2b_product_group_packages[' . $post_id . '][' . $group->ID . ']',
                                'label'         => __( 'Packages', 'woocommerce-b2b' ),
                                'description'   => __( 'Force customers to purchase product by pack increment. Insert how much products are in every pack. Set to 0 to disable', 'woocommerce-b2b' ),
                                'desc_tip'      => true,
                                'wrapper_class' => 'wcb2b-form-field',
                                'required'      => true,
                                'value'         => 0,
                                'custom_attributes'     => array(
                                    'min'   => 0
                                )
                            );
                            if ( is_array( $product_group_packages ) && array_key_exists( $group->ID, $product_group_packages ) ) {
                                $step = $product_group_packages[$group->ID];
                                $args['value'] = intval( $step );
                            }
                            woocommerce_wp_text_input( $args );
                        ?>

                    </div>
                    <div class="wcb2b-form wcb2b-form-inline">
                        
                        <?php
                            $args = array(
                                'id'            => '_wcb2b_product_group_min_' . $group->ID,
                                'type'          => 'number',
                                'name'          => 'wcb2b_product_group_min[' . $post_id . '][' . $group->ID . ']',
                                'label'         => __( 'Minimum quantity', 'woocommerce-b2b' ),
                                'description'   => __( 'Force customers to purchase minimum quantity of this product. Set to 0 to disable', 'woocommerce-b2b' ),
                                'desc_tip'      => true,
                                'wrapper_class' => 'wcb2b-form-field',
                                'required'      => true,
                                'value'         => 0,
                                'custom_attributes'     => array(
                                    'min'   => 0
                                )
                            );
                            if ( is_array( $product_group_min ) && array_key_exists( $group->ID, $product_group_min ) ) {
                                $min = $product_group_min[$group->ID];
                                $args['value'] = intval( $min );
                            }
                            woocommerce_wp_text_input( $args );
                        ?>

                    </div>
                    <div class="wcb2b-form wcb2b-form-inline">
                        
                        <?php
                            $args = array(
                                'id'            => '_wcb2b_product_group_max_' . $group->ID,
                                'type'          => 'number',
                                'name'          => 'wcb2b_product_group_max[' . $post_id . '][' . $group->ID . ']',
                                'label'         => __( 'Maximum quantity', 'woocommerce-b2b' ),
                                'description'   => __( 'Force customers to purchase maximum quantity of this product. Set to 0 to disable', 'woocommerce-b2b' ),
                                'desc_tip'      => true,
                                'wrapper_class' => 'wcb2b-form-field',
                                'required'      => true,
                                'value'         => 0,
                                'custom_attributes'     => array(
                                    'min'   => 0
                                )
                            );
                            if ( is_array( $product_group_max ) && array_key_exists( $group->ID, $product_group_max ) ) {
                                $max = $product_group_max[$group->ID];
                                $args['value'] = intval( $max );
                            }
                            woocommerce_wp_text_input( $args );
                        ?>

                    </div>
                </section>
                <?php endforeach; ?>

            <?php endif; ?>
        
        </div>
    </div>
</div>