<?php

/**
 * WooCommerce B2B Update Functions
 *
 * @version 3.1.0
 */

defined( 'ABSPATH' ) || exit;

function wcb2b_vatnumber_required_300() {
    return update_option( 'wcb2b_vatnumber_required', 'yes' );
}

function wcb2b_fix_prices_300() {
    global $wpdb;

    $decimals_separator = wc_get_price_decimal_separator();
    $thousand_separator = wc_get_price_thousand_separator();

    $wpdb->query( "UPDATE {$wpdb->postmeta} SET meta_value = REPLACE( meta_value, '" . $thousand_separator . "', '' ) WHERE meta_key = 'wcb2b_product_group_prices';" );
    $wpdb->query( "UPDATE {$wpdb->postmeta} SET meta_value = REPLACE( meta_value, '" . $decimals_separator . "', '.' ) WHERE meta_key = 'wcb2b_product_group_prices';" );
    return true;
}

function wcb2b_set_page_visibility_301() {
    if ( $pages = get_pages() ) {
        $groups = wcb2b_get_groups();
        $ids = wp_list_pluck( $groups->posts, 'ID' );
        foreach ( $pages as $page ) {
            if ( ! metadata_exists( 'post', $page->ID, 'wcb2b_group_visibility' ) ) {
                add_post_meta( $page->ID, 'wcb2b_group_visibility', $ids, true );
            }
        }
    }
    return true;
}

function wcb2b_set_product_cat_visibility_301() {
    if ( $terms = get_terms( array( 'taxonomy' => 'product_cat', 'hide_empty' => false ) ) ) {
        $groups = wcb2b_get_groups();
        $ids = wp_list_pluck( $groups->posts, 'ID' );
        foreach ( $terms as $term ) {
            if ( ! metadata_exists( 'term', $term->term_id, 'wcb2b_group_visibility' ) ) {
                add_term_meta( $term->term_id, 'wcb2b_group_visibility', $ids, true );
            }
        }
    }
    return true;
}

function wcb2b_remove_deprecated_options_307() {
    return delete_option( 'wcb2b_enable_quotations' );
}

function wcb2b_set_packages_by_group_310() {
    global $wpdb;
    $results = $wpdb->get_results( "SELECT post_id, meta_value FROM {$wpdb->prefix}postmeta WHERE meta_key = 'wcb2b_step'", OBJECT );
    $groups = wp_list_pluck( wcb2b_get_groups()->posts, 'ID' );
    foreach ( $results as $result ) {
        if ( metadata_exists( 'post', $result->post_id, 'wcb2b_product_group_packages' ) ) {
            continue;
        }
        $values = array_fill_keys( $groups, $result->meta_value );
        $product = wc_get_product( $result->post_id );

        if ( in_array( $product->get_type(), array( 'simple' ) ) ) {
            add_post_meta( $result->post_id, 'wcb2b_product_group_packages', $values, true );
        }
        if ( in_array( $product->get_type(), array( 'variable' ) ) ) {
            $variations = wp_list_pluck( $product->get_available_variations(), 'variation_id' );
            foreach ( $variations as $variation ) {
                if ( metadata_exists( 'post', $variation, 'wcb2b_product_group_packages' ) ) {
                    continue;
                }
                add_post_meta( $variation, 'wcb2b_product_group_packages', $values, true );
            }
        }
        delete_post_meta( $result->post_id, 'wcb2b_step', $result->meta_value );
    }
    return true;
}

function wcb2b_set_minquantity_by_group_310() {
    global $wpdb;
    $results = $wpdb->get_results( "SELECT post_id, meta_value FROM {$wpdb->prefix}postmeta WHERE meta_key = 'wcb2b_min'", OBJECT );
    $groups = wp_list_pluck( wcb2b_get_groups()->posts, 'ID' );
    foreach ( $results as $result ) {
        if ( metadata_exists( 'post', $result->post_id, 'wcb2b_product_group_min' ) ) {
            continue;
        }
        $values = array_fill_keys( $groups, $result->meta_value );
        $product = wc_get_product( $result->post_id );

        if ( in_array( $product->get_type(), array( 'simple' ) ) ) {
            add_post_meta( $result->post_id, 'wcb2b_product_group_min', $values, true );
        }
        if ( in_array( $product->get_type(), array( 'variable' ) ) ) {
            $variations = wp_list_pluck( $product->get_available_variations(), 'variation_id' );
            foreach ( $variations as $variation ) {
                if ( metadata_exists( 'post', $variation, 'wcb2b_product_group_min' ) ) {
                    continue;
                }
                add_post_meta( $variation, 'wcb2b_product_group_min', $values, true );
            }
        }
        delete_post_meta( $result->post_id, 'wcb2b_min', $result->meta_value );
    }
    return true;
}

function wcb2b_set_maxquantity_by_group_310() {
    global $wpdb;
    $results = $wpdb->get_results( "SELECT post_id, meta_value FROM {$wpdb->prefix}postmeta WHERE meta_key = 'wcb2b_max'", OBJECT );
    $groups = wp_list_pluck( wcb2b_get_groups()->posts, 'ID' );
    foreach ( $results as $result ) {
        if ( metadata_exists( 'post', $result->post_id, 'wcb2b_product_group_max' ) ) {
            continue;
        }
        $values = array_fill_keys( $groups, $result->meta_value );
        $product = wc_get_product( $result->post_id );

        if ( in_array( $product->get_type(), array( 'simple' ) ) ) {
            add_post_meta( $result->post_id, 'wcb2b_product_group_max', $values, true );
        }
        if ( in_array( $product->get_type(), array( 'variable' ) ) ) {
            $variations = wp_list_pluck( $product->get_available_variations(), 'variation_id' );
            foreach ( $variations as $variation ) {
                if ( metadata_exists( 'post', $variation, 'wcb2b_product_group_max' ) ) {
                    continue;
                }
                add_post_meta( $variation, 'wcb2b_product_group_max', $values, true );
            }
        }
        delete_post_meta( $result->post_id, 'wcb2b_max', $result->meta_value );
    }
    return true;
}

function wcb2b_set_tax_display_by_group_310() {
    $option = get_option( 'wcb2b_split_taxes' );
    if ( $option === 'yes' ) {
        $groups = wcb2b_get_groups();
        $ids = wp_list_pluck( $groups->posts, 'ID' );
        foreach ( $ids as $id ) {
            if ( $id == get_option( 'wcb2b_guest_group' ) ) {
                update_post_meta( $id, 'wcb2b_group_tax_display', 'incl' );
            } else {
                update_post_meta( $id, 'wcb2b_group_tax_display', 'excl' );
            }
        }
    }
    return update_option( 'wcb2b_tax_display', $option ) && delete_option( 'wcb2b_split_taxes' );
}

function wcb2b_set_moderate_registration_by_group_310() {
    $option = get_option( 'wcb2b_moderate_customer_registration' );
    if ( $option === 'yes' ) {
        $groups = wcb2b_get_groups();
        $ids = wp_list_pluck( $groups->posts, 'ID' );
        foreach ( $ids as $id ) {
            update_post_meta( $id, 'wcb2b_group_moderate_registration', 1 );
        }
    }
    return true;
}