<?php

/**
 * WooCommerce B2B Product tier prices
 *
 * @version 3.0.7
 */

defined( 'ABSPATH' ) || exit;

?>

<ul class="wcb2b-tier_prices">

    <?php
        foreach ( $tier_prices as $tier_quantity => $tier_price ) {
            printf( '<li>' . __( 'Buy %s for %s each and save %s', 'woocommerce-b2b' ) . '</li>',
                '<strong>' . $tier_quantity . '</strong>',
                '<strong>' . wcb2b_display_tier_price( $tier_price ) . '</strong>',
                '<strong>' . number_format( ( ( $price - $tier_price ) / $price ) * 100, 2, wc_get_price_decimal_separator(), '' ) . '%</strong>'
            );
        }
    ?>

</ul>
<br />