<?php

/**
 * WooCommerce B2B Uninstall
 *
 * Uninstalling WooCommerce deletes user roles and options
 *
 * @version 3.1.4
 */

// Exit if accessed directly
defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

global $wpdb;

// Delete options and settings
delete_option( 'wcb2b_version' );
delete_option( 'wcb2b_notice_shown' );
delete_option( 'wcb2b_enable' );
delete_option( 'wcb2b_hide_prices' );
delete_option( 'wcb2b_tax_display' );
delete_option( 'wcb2b_add_invoice_email' );
delete_option( 'wcb2b_invoice_email_required' );
delete_option( 'wcb2b_add_vatnumber' );
delete_option( 'wcb2b_vatnumber_required' );
delete_option( 'wcb2b_vies_validation' );
delete_option( 'wcb2b_min_purchase_amount' );
delete_option( 'wcb2b_display_min_purchase_cart_message' );
delete_option( 'wcb2b_prevent_checkout_button' );
delete_option( 'wcb2b_show_customer_group' );
delete_option( 'wcb2b_moderate_customer_registration' );
delete_option( 'wcb2b_extend_registration_form' );
delete_option( 'wcb2b_registration_notice' );
delete_option( 'wcb2b_price_rules' );
delete_option( 'wcb2b_show_customer_discount' );
delete_option( 'wcb2b_show_customer_discount_product' );
delete_option( 'wcb2b_product_cat_visibility' );
delete_option( 'wcb2b_page_visibility' );
delete_option( 'wcb2b_redirect_not_allowed' );
delete_option( 'wcb2b_default_group' );
delete_option( 'wcb2b_guest_group' );
delete_option( 'wcb2b_restricted_catalog' );
delete_option( 'wcb2b_account_quotations_endpoint' );
delete_option( 'wcb2b_quick_order_page' );
delete_option( 'wcb2b_tax_exemption_countries' );
delete_option( 'wcb2b_show_rrp' );
delete_option( 'wcb2b_show_barcode' );
delete_option( 'wcb2b_show_already_bought' );
delete_option( 'wcb2b_show_sales' );
delete_option( 'wcb2b_show_shippings_tab' );

// Delete users data.
$wpdb->query( "DELETE FROM {$wpdb->posts} WHERE post_type IN ( 'wcb2b_group' );" );
$wpdb->query( "DELETE FROM {$wpdb->postmeta} WHERE meta_key IN ( '_billing_vat', '_billing_invoice_email', 'wcb2b_product_group_packages', 'wcb2b_product_group_min', 'wcb2b_product_group_max', 'wcb2b_barcode', 'wcb2b_group_discount', 'wcb2b_product_group_prices', 'wcb2b_product_group_tier_prices', 'wcb2b_group_min_purchase_amount', 'wcb2b_group_tax_exemption', 'wcb2b_group_packaging_fee', 'wcb2b_group_gateways', 'wcb2b_group_shippings', 'wcb2b_group_terms_conditions', 'wcb2b_group_visibility', '_wcb2b_coupon_group', '_wcb2b_external_invoice_number' );" );
$wpdb->query( "DELETE FROM {$wpdb->termmeta} WHERE meta_key IN ( 'wcb2b_group_visibility' );" );
$wpdb->query( "DELETE FROM {$wpdb->usermeta} WHERE meta_key IN ( 'wcb2b_group', 'wcb2b_status', 'wcb2b_unpaid_limit', 'billing_vat' );" );

// Clear any cached data that has been removed
flush_rewrite_rules();
wp_cache_flush();